(ns micro-blog.is-tech
  (:require
   [micro-blog.config :refer [config]]
   [taoensso.telemere :as tel]
   [clj-http.client :as client]))

(defn is-tech? [post-text]
  (let [url (str (:mistral-host @config) "/v1/conversations")
        headers {"Content-Type" "application/json"
                 "Accept" "application/json"
                 "Authorization" (str "Bearer " (@config :mistral-api-key))}
        body {:inputs post-text
              :stream false
              :agent_id (@config :mistral-agent-id)}]
    (tel/log! {:level :info :data {:url url :agent_id (:agent_id body)}} "making request to mistral agent")
    (->
     (client/post url {:headers headers
                       :form-params body
                       :content-type :json
                       :as :json})
     :body
     :outputs
     first
     :content
     (#(if (= "1" %) true false)))))
