# GEMINI INK DEMO SERVER

This little node js server is a demonstration of playing text-only narrative games created with Ink
(https://github.com/inkle/ink) over the gemini protocol (https://gemini.circumlunar.space/). It uses
basically a bunch of standard nodejs functionality and inkjs (https://github.com/y-lohse/inkjs). The
demo game is The Intercept, also made by Inkle, not me! So don't give me credit for the game
(https://github.com/inkle/the-intercept).

To run this. You will need to install node and npm. You will also need a gemini server cert!

Here's how to generate a self-signed cert using openssl:

> openssl req -newkey rsa:2048 -nodes -keyout server-key.pem -x509 -days 3650 -out server-cert.pem

This nodejs server expects the key and cert to be in those specific file names. The most important
detail when generating is that you set the common name to the name of your host. If you're just
testing locally, that's localhost. Otherwise it's your server domain.

Anyway, to actually run the server, first install dependencies:

> npm install

Currently that's only inkjs. We're version locked at the moment to 1.11.0. This version locks us to
ink games compiled with inklecate 0.9.0.

To get it running at all, it's a simple:

> nodejs index.js

That'll boot it in local mode though (meaning your cert will need to be for localhost). To boot it in
public server mode, you'll need to atleast set the host address:

> GEMINI_INK_ADDR=your-gemini-server.com nodejs index.js

You can all set an ink json file of your choice with GEMINI_INK_FILE, and the port with
GEMINI_INK_PORT.

Anyway. That should be everything. index.js is fairly well commented so if you want to repurpose this
it should be quite easy. Warning that I'm not very experienced with javascript at this time. So I'm
probably doing something disgusting.

If you have any questions, comments, or anything, please reach out to me (mosfetarium.com/about). I'd
love to hear from you :)
