// @ts-check

import eslint from '@eslint/js';
import { defineConfig } from 'eslint/config';
import tseslint from 'typescript-eslint';

export default defineConfig(
  eslint.configs.recommended,
  tseslint.configs.recommended,
  {
    rules: {
      'no-console': 'error',
    },
  },
  {
    rules: {
      '@typescript-eslint/no-unused-vars': ['off', { varsIgnorePattern: '^_' }],
    },
  },
  {
    rules: {
      '@typescript-eslint/no-explicit-any': ['warn', { ignoreRestArgs: true }],
    },
  },
  {
    files: ['src/1_domain/**/*.ts'],
    rules: {
      '@typescript-eslint/no-restricted-imports': [
        'error',
        {
          patterns: [
            {
              regex: '2_app',
              message: 'The domain layer should not depend on the app layer.',
            },
            {
              regex: '3_infra',
              message: 'The domain layer should not depend on the infra layer.',
            },
          ],
        },
      ],
    },
  },
  {
    files: ['src/2_app/**/*.ts'],
    rules: {
      '@typescript-eslint/no-restricted-imports': [
        'error',
        {
          patterns: [
            {
              regex: '3_infra',
              message: 'The app layer should not depend on the infra layer.',
            },
          ],
        },
      ],
    },
  },
);
