# Cooking Helper Script

A CLI tool for creating, editing, and viewing cooking notes stored in PocketBase. This allows Claude Code to integrate with your cooking notes feature.

## Setup

The script uses your existing `.env` file for PocketBase credentials:
- `POCKET_BASE_HOST` - PocketBase server URL
- `POCKET_BASE_PASSWORD` - PocketBase user password

## Commands

### List all cooking notes
```bash
npx ts-node scripts/cooking-helper.ts list
```
Returns JSON with all cooking notes, sorted by most recently updated.

### View a specific note
```bash
npx ts-node scripts/cooking-helper.ts view <slug>
```
Example: `npx ts-node scripts/cooking-helper.ts view dashi`

### Fetch recipe from URL
```bash
npx ts-node scripts/cooking-helper.ts fetch-recipe <url>
```
Fetches and parses a recipe from a URL. Returns extracted title and content to help write a cooking note in your style.

Example: `npx ts-node scripts/cooking-helper.ts fetch-recipe https://example.com/recipe`

### Create a new note
```bash
npx ts-node scripts/cooking-helper.ts create '<json>'
```
Create a new cooking note from JSON data.

**Required fields:** `title`, `slug`, `content`
**Optional fields:** `description`, `tags` (array of strings)

Example:
```bash
npx ts-node scripts/cooking-helper.ts create '{"title":"Pasta Carbonara","slug":"pasta-carbonara","description":"Classic Italian pasta","content":"## Ingredients\n- Pasta\n- Eggs\n- Guanciale\n\n## Steps\n1. Cook pasta\n2. Make sauce","tags":["pasta","italian","quick"]}'
```

### Update a note
```bash
npx ts-node scripts/cooking-helper.ts update <id> '<json>'
```
Update an existing note by ID. Only fields provided in JSON will be updated.

Example:
```bash
npx ts-node scripts/cooking-helper.ts update abc123 '{"content":"Updated content here","tags":["updated","tag"]}'
```

### Delete a note
```bash
npx ts-node scripts/cooking-helper.ts delete <id>
```
Permanently delete a cooking note.

## Workflow Example

### Creating a recipe from a website

1. Fetch the recipe URL:
```bash
npx ts-node scripts/cooking-helper.ts fetch-recipe https://www.example.com/recipe
```

2. Review the extracted content

3. Write a cooking note in your style based on the content (using Claude's assistance)

4. Create the note:
```bash
npx ts-node scripts/cooking-helper.ts create '{"title":"...","slug":"...","description":"...","content":"...","tags":[...]}'
```

## Output Format

All commands return JSON output for easy parsing:

**Success response:**
```json
{
  "success": true,
  "message": "...",
  "note": { ... }
}
```

**Error response:**
```json
{
  "success": false,
  "error": "error message"
}
```

## Tips

- **Slugs**: Use lowercase, hyphenated slugs (e.g., `pasta-carbonara`)
- **Content**: Use Markdown format with sections like `## Ingredients`, `## Steps`, `## Notes`
- **Tags**: Use simple, lowercase tags for categorization (e.g., `pasta`, `vegetarian`, `quick`)
- **IDs**: Get IDs from `list` or `view` commands to use in `update`/`delete`

## With Claude Code

You can use this script directly in Claude Code to:
1. Ask Claude to create a cooking note from a recipe URL
2. Ask Claude to update existing notes
3. Ask Claude to view notes for reference

Example prompt: "Create a cooking note for pasta carbonara based on this URL: https://example.com/recipe"
