#!/bin/sh

set -e

# Run jj diff and prefix each line with "JJ: "
diff_output="$(jj diff | sed 's/^/JJ: /')"

# Add two newlines at the top (without the prefix)
final_output="\n\n$diff_output"

# Feed the string to jj desc --stdin
# Use printf to preserve newlines
printf "%b" "$final_output" | jj desc --stdin --edit
